# bvfx_OffsetmatrixHelperlayer v1.1
# by Magno Borgo
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com
# 
# Description:
# This Action will create a helper layer that will set the relative start of the Layer Matrix to that frame
# Making visualization and manipulation of the frames easier, especially with heavy distorted corner pin tracker layers.
#
# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#		endorse or promote products derived from this software without
#		specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#Version log
#
#1.1 - Adapted the script to run in older Silhouette Versions (4.1)


from fx import *
from tools.objectIterator import getObjects
from tools.objectIterator import ObjectFinder


def offset_matrix(layer):
	node = activeNode()
	session = activeSession()

	layers = getObjects(node.children, types=[Layer])
	exists = False

	for alayer in layers:
		if alayer.parent.type == "RotoNode":
			if alayer.label == "MatrixOffset_HELPER":
				helperlayer = alayer
				exists = True
				
				
	if exists == False:
		#v4.1 can't create Layers
		try:
			helperlayer = Layer("MatrixOffset_HELPER")
			node.property("objects").addObjects([helperlayer])
		except:
			print "\nYour version of Silhouette doesn't support Layer creation,\n please create manually a Layer called: MatrixOffset_HELPER\n(case sensitive)\n\n"
    		return
    	
       
       


	try:
		helperlayer.visible = False
		helperlayer.locked = True
		#v4.1 can't do this
		setActiveLayer(helperlayer)
	except:
		pass
	

	thisframe_matrix = layer.getTransform(player.frame)
	identity = Matrix()
	offset_matrix = -thisframe_matrix * identity 
	layer_matrix = helperlayer.property("transform.matrix")
	layer_matrix.constant = False
	matrixEditor = PropertyEditor(layer_matrix)
	
	for i in range(0, int(session.duration)):
		matrixEditor.setValue(layer.getTransform(i),i)
		matrix = layer.getTransform(i) * offset_matrix
		matrixEditor.setValue(matrix,i)
	matrixEditor.execute()	
	


class OffsetmatrixHelperlayer(Action):
	"""Creates a helper layer, setting the viewer stabilization relative to the current frame.
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Offset Matrix Helper Layer")

	def available(self):
		node = activeNode()
		session = activeSession()
		assert session, "Select a Session"
		rotoNode = session.node(type="RotoNode")
		assert rotoNode, "The session does not contain a Roto Node"


	def execute(self):
		session = activeSession()
		rotoNode = session.node(type="RotoNode")
		layers = getObjects(selection(), types=[Layer])
		shapes = getObjects(selection(), types=[Shape])
		beginUndo("Offset Matrix Helper Layer") 

		if len(shapes) == 1:
			if shapes[0].parent.type == "Layer":
				offset_matrix(shapes[0].parent)
		elif len(layers) == 1:
			offset_matrix(layers[0])
		else:
			status("Select one Shape or one Layer")
		endUndo()

addAction(OffsetmatrixHelperlayer())