#Boundary Visual Effects -Increase Stroke Width
#Version 1.0
# 
# This action will enable you to Iecrease open shapes stroke width by 0.1 increments
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v4.1
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.

from fx import *
from tools.objectIterator import getObjects

class increaseStrokeWidth(Action):
	"""Increases open shapes stroke width by 0.1 increments
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Increase Stroke Width")

	def available(self):
		shapes = getObjects(selection(), types=[Shape])
		assert len(shapes) > 0, "There must be one or more selected shapes"

	def execute(self):
		shapes = getObjects(selection(), types=[Shape])

		beginUndo("bvfx Increase Stroke Width") 
	
		for shape in shapes:			
			if not shape.closed:		
				strokewidth = shape.property("strokeWidth").getValue() 
				strokewidth = strokewidth + 0.0092
				shape.property("strokeWidth").setValue(strokewidth)

		endUndo()

addAction(increaseStrokeWidth())


