#Boundary Visual Effects - Export Stroke and Shapes to Nuke
#Version 1.0
# 
# This action will enable you to export strokes to Nuke.
# Select the shapes and run the Action
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v4.5 (not tested on previous versions)
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.
	
"""
KNOW issues:

On Windows you'll need to have python installed and visible on path to use the RE module

open BEZIER curves can cause several problems, including broken nuke scripts.
BEZIER shapes animated do no export well, will create a corrupted file and will cause Nuke to crash when creating the strokes.
animated open BEZIER inside Layers will crash Silhouette export
bsplines MUST have a minimum of 4 points
"""


import fx, os, re, time
from fx import *
from tools.objectIterator import getObjects
import fileinput
import sys

def openCloseShapes(shape):
	pathProp = shape.property("path")
	keys = pathProp.keys
	shapepath = shape.evalPath(0.0) #just set to 0.0 
	if shapepath.closed:
		shapepath.closed = False
	else:
		shapepath.closed = True



def replaceAll(file,searchExp,replaceExp,openShapelist):
	for i in range(len(openShapelist)):
		openShapelist[i] = re.sub(r'-','_', openShapelist[i])
		openShapelist[i]= openShapelist[i][2:-1]
   	authorizechange1 = False
   	authorizechange2 = False
	for line in fileinput.input(file, inplace=1):
		name = re.findall('NodeName: "(.*?)"', line)
		
		if name != []:
			name[0] = name[0][2:-1]
	   	 	if name[0] in openShapelist:
	   	 		authorizechange1 = True
	   	 		authorizechange2 = False


		if searchExp in line:
			if authorizechange2:
				line = line.replace(searchExp,replaceExp)
				authorizechange2 = False
			if authorizechange1:
				line = line.replace(searchExp,replaceExp)
				authorizechange1 = False
				authorizechange2 = True
		sys.stdout.write(line)

def traverseLayers(layer, list):
	if layer.parent.type == "Layer":
		if layer.parent not in list:
			list.append(layer.parent)
			traverseLayers(layer.parent,list)
			
def doExportE(self, path):

	node = activeNode()
	session = node.session
	width, height = session.size


	sel = selection()
	if len(sel) == 0:
		status("Select some shapes before trying to export!")
	else:	
		path = os.path.abspath(path)
		module = io_modules["Nuke 6.2+ Shapes"]
		shapes = []
		openshapesList = []
		shapeNames = []
		openShapes = []
		rotoShapes = []
		rotoShapesnames = []
		shapeData = ""
		ofensiveShapes = []
		
		#secure the environment before proceeding.
		for shape in sel:
			spath = shape.evalPath(0)
			spoints = spath.points
			if len(spoints) < 4:
				ofensiveShapes.append(shape)
				
		if len(ofensiveShapes) > 0:
			msg = "Script interrupted, shapes must have at least 4 points!\nProblematic Shapes are selected.\n\n"
			print msg
			fx.displayWarning(msg, title="Stroke Exporter Warning")
			select(ofensiveShapes)	
			raise

		
		for shape in sel:
			pathProp = shape.property("path")
			keys = pathProp.keys
			shapepath = shape.evalPath(0.0) #just set to 0.0 
			if shapepath.type == 0 and not shape.closed: #open bezier shapes
				ofensiveShapes.append(shape)
			
		if len(ofensiveShapes) > 0:
			msg = "Script interrupted, open Bezier shapes \ndo not export well!\nBezier Shapes are selected.\n\n"
			print msg
			fx.displayWarning(msg, title="Stroke Exporter Warning")
			select(ofensiveShapes)	
			raise




		
		for shape in sel:	
			if shape.type == "Shape":
				shapes.append(shape)
				shapeNames.append(shape.label)
				if not shape.closed:
					strokewidth = shape.property("strokeWidth").getValue() 
					if strokewidth > 0:
						openShapes.append(shape.id)
						shapeData += "LABEL:!:" + shape.label
						shape.label = shape.id
						openshapesList.append(shape)
						openCloseShapes(shape)
						shapeData += ":!:ID:!:" + shape.id
					
						
						if strokewidth > 0:
							shapeData = shapeData + ":!:STROKE:!:" + str(strokewidth*height/100)
	
						
						shapeData += "\n"
				else:
					rotoShapes.append(shape)
					rotoShapesnames.append(shape.label)
					shapeData += "LABEL:!:" + shape.label
					shape.label = shape.id
					shapeData += ":!:ID:!:" + shape.id + ":!:STROKE:!:0\n"

				
			
		parentLayers = []
		if len(shapes) > 0:
			for shape in shapes:			
				if shape.parent.type == "Layer":
					if shape.parent not in parentLayers:
						parentLayers.append(shape.parent)
						traverseLayers(shape.parent,parentLayers)


				

		
		layerNames = []
		for layer in parentLayers:

			layerNames.append(layer.label)
			shapeData += "LABEL:!:" + layer.label
			shapeData += ":!:ID:!:" + layer.id + ":!:STROKE:!:layer\n"
			layer.label = layer.id
	
		
		self.counter += 1
		dir = os.path.dirname(path)
		base = os.path.basename(path)
		base, ext = os.path.splitext(base)
		shapePath = os.path.join(dir, base + ext)
		
		
		module.export(shapePath)
		status("Nuke 6.2+ Shapes exported to " + path)
		
		c = 0
		for shape in openshapesList:
			openCloseShapes(shape)

		for shape in shapes:
			shape.label = shapeNames[c]
			c+=1
		c=0
		for layer in parentLayers:
			layer.label = layerNames[c]
			c+=1

		c=0
		for layer in rotoShapes:
			layer.label = rotoShapesnames[c]
			c+=1

			
		replaceAll(shapePath,'Flag: 8192', 'Flag: 8224', openShapes)

		
		f = open(shapePath, 'a')
		note = 'Group { inputs 0 name BoundaryVFXStrokeImporterMetadata }\nStickyNote {inputs 0 name StickyNote1 label "BoundaryVFXStrokeImporter!\n' + shapeData + '"}\nOutput { inputs 0 name Output1 }\nend_group'
		
		f.write(note) 
		f.close()
		print "Exported %s shape(s) and %s layer(s) on " % (len(shapes), len(parentLayers)), time.strftime("%a, %d %b %Y %H:%M:%Sgmt", time.gmtime())


class ExportNukeStrokesE(Action):
	"""Export shapes to individual Nuke files"""

	def __init__(self):
		Action.__init__(self, "Nuke 6.2+ with Strokes", type=Action.ShapeExporter, extension="nk")
		self.counter = 0

	def available(self):
		assert len(selection()) > 0, "Select one or more shapes or Layers"

	def execute(self, path):
		print "\n**********************"
		print "Nuke StrokeExporter v01"
		print "By Magno Borgo"
		print "BoundaryVFX"
		print "**********************"
		doExportE(self, path)

addAction(ExportNukeStrokesE())

