#Boundary Visual Effects - Composite Mode with No Overlay Combo
#Version 1.0
# Have you ever finding yourself pressing "4" for composite mode and them "0" to remove the overlay several times a day?
# This script creates a special combo mode of composite with no overlay, with 3 bg colors options: neutral grey, white and black
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v3 and up
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.
	
#Know issues: 
#Sometimes the script fails, I've never being able to debug it, but just press 1, 2, 3 ,4 to go to other modes and try to use it again.

#USAGE
# Press the shortcuts 5, 6, or 7 to enable the combo mode, and press again to go back to the original configuration.



import fx

def callMethod(func, *args, **kwargs):
	def _return_func():
		return func(*args, **kwargs)
	return _return_func

    


toggle = False
last_toggle = None
store_last_mode = None

def toggleCompNoOverlay(bgcolor):
    global toggle, store_last_mode, last_toggle
    session = fx.activeSession()
    
    colordict = {"gray": fx.Color(0.5,0.5,0.5,1),"black": fx.Color(0,0,0,1),"white": fx.Color(1,1,1,1)}
    
	
    if fx.activeNode() == session.node(type="RotoNode"): 
        if last_toggle == None or last_toggle == bgcolor:
  
        	toggle = not toggle

		

		
        if toggle:

            if last_toggle == None:
                store_last_mode = fx.viewer.viewMode
                
            fx.viewer.setOverlay(False)            
            fx.prefs["composite.backgroundColor"] = colordict[bgcolor]

            
            fx.viewer.setViewMode(3)
            last_toggle = bgcolor

            
        else:
            fx.viewer.setOverlay(True)
            fx.viewer.setViewMode(store_last_mode)
            last_toggle = None
            
    else: 

        bindlist = {"gray":4, "black":5, "white":6}
        fx.viewer.setViewMode(bindlist[bgcolor])
        
        

    
fx.bind("5", callMethod(toggleCompNoOverlay, "gray"))
fx.bind("6", callMethod(toggleCompNoOverlay, "black"))
fx.bind("7", callMethod(toggleCompNoOverlay, "white"))