# bvfx_Import_Nuke_Corner_Pin v1.1	
# by Magno Borgo
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.5 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com
# 
# Description:
# This Action will import a Nuke Corner Pin node from clipboard into Silhouette
# Useful to import planar tracking data from Mocha or Nuke.

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#		endorse or promote products derived from this software without
#		specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#Version log
##1.1 Fixed pixel aspect ratio issue

from fx import *
from tools.objectIterator import getObjects
from tools.objectIterator import ObjectFinder
from tools.pyperclip import *
import time

def applyCornerPin(cpindata):
	node = activeNode()
	session = node.session
#	rotoNode = session.node(type="RotoNode")
	to1 = Tracker("cpin_to1")
	to2 = Tracker("cpin_to2")
	to3 = Tracker("cpin_to3")
	to4 = Tracker("cpin_to4")	
	trackers = [to1,to2,to3,to4]
	node.property("objects").addObjects([to1])
	node.property("objects").addObjects([to2])
	node.property("objects").addObjects([to3])
	node.property("objects").addObjects([to4])
	
	for item in cpindata:
		time1 = item[0] - session.startFrame
		n = 1
		for trk in trackers:
			position = trk.property("position")
			position.constant = False
			pEditor = PropertyEditor(position)
 			#==================================================================
 			# Height on Silhouette = session.height - Nuke height
 			# Mapping from silhouette coordinate to pixel coordinates:
 			# Value - half of the width/height / height session
 			#==================================================================
			x = ((item[n] - (session.size[0]/2))/session.size[1])* session.pixelAspect
			y = ((session.size[1]-item[n+1]) - (session.size[1]/2))/session.size[1]
			pEditor.setValue(Point3D(x,y,0),time1)
			n+=2
			pEditor.execute()
	
	firstframe = cpindata[0][0]
	if firstframe != session.startFrame:
		for trk in trackers:
			position = trk.property("position")	
			pEditor = PropertyEditor(position)
			pEditor.deleteKey(0)
			pEditor.execute()
	print "Corner Pin Imported successfully", time.strftime("%a, %d %b %Y %H:%M:%Sgmt", time.gmtime())
		

def verifyClipboard(clipboard):
	
	if clipboard.count("CornerPin2D {") > 0 and clipboard.count("curve") > 0 : #"curve" identify animated trackers
		status("Nuke Corner Pin detected on Clipboard: Importing...")
		itens = clipboard.split("curve ") #gets each sequence of to"n" values, to1, to2, to3, to4
		valueList = []
		#=======================================================================
		# build the frames index
		# handles data coming from mocha and nuke "cut_paste"
		#=======================================================================
		subitem = itens[1].split("}")
		subitem = subitem[0].split()
		x=0
		while x < len(subitem):#
			if subitem[x].count("x") > 0:
				frame = subitem[x][1:]
				valueList.append([int(frame)])
				lastx = x
			else:
				if (x - lastx) > 1:
					valueList.append([int(subitem[lastx][1:]) + (x-lastx-1)])
			x+=1

		#=======================================================================
		# add to"n" values for the frames, format: [frame, to1x, to1y, to2x, to2y, to3x, to3y, to4x, to4y]
		#=======================================================================
		for i in range(1, len(itens)):
			subitem = itens[i].split("}")
			subitem = subitem[0].split()
			x = 1
			n = 0
			while x < len(subitem):#	
				if subitem[x].count("x") == 0:
					value = subitem[x]
 					valueList[n].append(float(value))
			 		n+=1
				x+=1
		return valueList	
	else:
		return False


class ImportNukeCornerPin(Action):
	"""Imports Nuke Corner Pins from clipboard"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Import Nuke Corner Pin")

	def available(self):
		node = activeNode()
		session = activeSession()
		assert session, "Select a Session"
		rotoNode = session.node(type="RotoNode")
		assert rotoNode, "The session does not contain a Roto Node"
		


	def execute(self):
#		session = activeSession()
#		rotoNode = session.node(type="RotoNode")

		print "\n**********************\nbvfx_Import_Nuke_Corner_Pin v1.0\nBy Magno Borgo\nBoundaryVFX\n**********************"

		beginUndo("Import Nuke Corner Pin") 
		#=======================================================================
		#  pyperclip setup
		#=======================================================================
		if os.name == 'nt' or platform.system() == 'Windows':
		    import ctypes
		    clipboard = winGetClipboard()
		elif os.name == 'mac' or platform.system() == 'Darwin':
		    clipboard =  macGetClipboard()
		elif os.name == 'posix' or platform.system() == 'Linux':
		    xclipExists = os.system('which xclip') == 0
		    if xclipExists:
		        clipboard =  xclipGetClipboard()
		    else:
		        xselExists = os.system('which xsel') == 0
		        if xselExists:
		            clipboard =  xselGetClipboard()
		        try:
		            import gtk
		            clipboard = gtkGetClipboard()
		        except:
		            try:
		                import PyQt4.QtCore
		                import PyQt4.QtGui
		                app = QApplication([])
		                cb = PyQt4.QtGui.QApplication.clipboard()
		                clipboard =  qtGetClipboard()
		            except:
		                raise Exception('Pyperclip requires the gtk or PyQt4 module installed, or the xclip command.')
		#=======================================================================
		# end of pyperclip setup
		#=======================================================================

		checkClipboard = verifyClipboard(clipboard)
		if not checkClipboard:
			status("No valid clipboard data detected, aborting script.")
			print "No valid clipboard data detected, aborting script.", time.strftime("%a, %d %b %Y %H:%M:%Sgmt", time.gmtime())
		else:
			applyCornerPin(checkClipboard)	
		endUndo()

addAction(ImportNukeCornerPin())