# Boundary Visual Effects - bvfxKeyframVisibility
# Version 2.0
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will enable you keyframe visibility when working on fullscreen mode, without the need of clicking on the visibility icon
# It works exactly as using the visibility icon on the Object List, first use of the action will animate the shape visibility to off.
#===============================================================================

#===============================================================================
# Version Log
# v2 (2012/10/24)
# Added the "singleframe" mode: quick keyframe method for shapes that appears only on a single frame. 
# It will create 3 keyframes, leaving shape visibility on at the current frame only (OFF/ON/OFF)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#		endorse or promote products derived from this software without
#		specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
#Singleframe mode is used with the following code on sfxuser.py (usable only with keyboard shortcut):
'''
def keyframeVisibilitySingle():
    action = fx.actions["keyframeVisibility"]
    if action:
        action.execute("singleframe")

fx.bind('Shift+n', keyframeVisibilitySingle)

#default mode:
def keyframeVisibility():
    action = fx.actions["keyframeVisibility"]
    if action:
        action.execute()

fx.bind("n", keyframeVisibility)
'''

#===============================================================================



import fx
from fx import *
from tools.objectIterator import getObjects

class keyframeVisibility(Action):
	"""Creates keyframes without clicking on the visibility icon
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Keyframe Visibility")

	def available(self):
		shapes = getObjects(selection(), types=[Shape])
		assert len(shapes) > 0, "There must be one or more selected shapes"

	def execute(self, type="normal"):
		shapes = getObjects(selection(), types=[Shape])


		beginUndo("bvfx Keyframe Visibility ON/OFF") 
		print "test"
		node = activeNode()
		session = node.session
		startFrame = session.startFrame

		actualframe = player.frame
		wasConstant = False
		for shape in shapes:			
			opacity = shape.property("opacity")
			if opacity.constant:
				opacity.constant = False		
				wasConstant = True
				
			if type == "normal":	
				if opacity.getValue(actualframe) > 0:
					opacity.setValue(0, actualframe)
				else:
					opacity.setValue(100, actualframe)
				if wasConstant and actualframe != 0:
					editor = PropertyEditor(opacity)				
					editor.deleteKey(0)
					editor.execute()
						
			if type == "singleframe":
				if actualframe not in (0,session.duration):
					if opacity.getValue(actualframe) > 0:
						opacity.setValue(0, actualframe-1)
						opacity.setValue(100, actualframe)
						opacity.setValue(0, actualframe+1)
						if actualframe != 1 and wasConstant:
							editor = PropertyEditor(opacity)				
							editor.deleteKey(0)
							editor.execute()
				elif actualframe == 0:
					if opacity.getValue(actualframe) > 0:
						opacity.setValue(100, actualframe)
						opacity.setValue(0, actualframe+1)
				elif actualframe == session.duration:
					if opacity.getValue(actualframe) > 0:
						opacity.setValue(0, actualframe-1)
						opacity.setValue(100, actualframe)
						editor = PropertyEditor(opacity)				
						editor.deleteKey(0)
						editor.execute()


		endUndo()
addAction(keyframeVisibility())


