# Boundary Visual Effects - bvfxKeyframetools
# Version 1.0
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will allow the following actions:
# Delete selected objects shape keyframes at current frame
# Delete shape keyframes before the current frame
# Delete shape keyframes after the current frame
#===============================================================================

#===============================================================================
# Version Log
# v1 (2012/10/24)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#       endorse or promote products derived from this software without
#       specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
#===============================================================================
# By default the action will delete selected shapes keyframes.
# Different modes (single frame, all keyframes after, all keyframes before), 
#are used with the following code on sfxuser.py (usable only with keyboard shortcut):

'''
def keyframeTools():
    action = fx.actions["keyframeTools"]
    if action:
        action.execute()

fx.bind('Shift+k', keyframeTools)

def keyframeToolsAfter():
    action = fx.actions["keyframeTools"]
    if action:
        action.execute("after")

fx.bind('Ctrl+Shift+k', keyframeToolsAfter)

def keyframeToolsBefore():
    action = fx.actions["keyframeTools"]
    if action:
        action.execute("before")

fx.bind('Alt+Shift+k', keyframeToolsBefore)

'''
#===============================================================================

from fx import *
from tools.objectIterator import *

class keyframeTools(Action):
    """Keyframe Actions
"""

    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Keyframe Tools")

    def available(self):
        shapes = getObjects(selection(), types=[Shape])
        assert len(shapes) > 0, "There must be one or more selected shapes"
        
    def execute(self, type="normal"):
        beginUndo("bvfx Keyframe Tools")

        node = activeNode()
        session = node.session
        shapelist = getObjects(selection(), types=[Shape])
        actualframe = player.frame
        
        for shape in shapelist:
            path = shape.property("path")
            if actualframe in path.keys:
                if type == "normal":
                    editor = PropertyEditor(path)
                    editor.deleteKey(path.keys.index(actualframe))
                    editor.execute()
                    
                if type == "before":
                    while path.keys.index(actualframe) > 0:
                      
                        editor = PropertyEditor(path)
                        editor.deleteKey(0)
                        editor.execute()
                    
                if type == "after":
                    while len(path.keys) > path.keys.index(actualframe) + 1:
                        editor = PropertyEditor(path)
                        editor.deleteKey(len(path.keys)-1)
                        editor.execute()
        endUndo()
addAction(keyframeTools())