# Boundary Visual Effects - bvf_KeyboardToggles
# Version 1.0
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# Keyboard toggles for quick interface use: Toggle stabilization, viewer gamma and viewer gain ON/FF, 
#===============================================================================

#===============================================================================
# Version Log
# v1 (2012/11/01)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#       endorse or promote products derived from this software without
#       specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
#===============================================================================
# add this file to your actions folder will do the trick, or copy the code inside your sfxuser.py
# customize your keyboard bindinds at will, but try to avoid conflicts with other shortcuts.


import fx

def toggleStabilize():
    if fx.viewer.stabilize:
        fx.status("Stabilize Off")
        fx.viewer.setStabilize(0)
    else:
        fx.status("Stabilize On")
        fx.viewer.setStabilize(1) 

#===============================================================================
fx.bind("Alt+s", toggleStabilize)
#===============================================================================

previous_gain = 0
def toggleviewerGain():
    global previous_gain
    if fx.viewer.exposure != 0:
        previous_gain = fx.viewer.exposure
        fx.viewer.exposure = 0
    else:
        fx.viewer.exposure = previous_gain
    
#===============================================================================
fx.bind("Ctrl+g", toggleviewerGain)
#===============================================================================

previous_gamma =1
def toggleviewerGamma():
    global previous_gamma
    if fx.viewer.gamma != 1:
        previous_gamma = fx.viewer.gamma
        fx.viewer.gamma = 1
    else:
        fx.viewer.gamma = previous_gamma
    
#===============================================================================
fx.bind("Ctrl+shift+g", toggleviewerGamma)
#===============================================================================



