# Boundary Visual Effects - Transfer Shapes
# Version 1.11
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.2.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will take shape(s) and copy to a new layer on a given timeline position,
# even if the Layers have different tracking information (transform matrix) applied to them
# It'll also delete all the keyframes of the shape, keeping just the current frame key.
#===============================================================================

#===============================================================================
# Version Log
# v1.11 (2013/01/23)
# if shapes are not in a layer (root), it will work
# v1.1 (2013/01/13)
# Fixed an error when layers had no matrix data assigned
# Print message when active layer is the shape's parent layer
# Avoid creation of duplicate shapes when a layer is selected
# v1 (2012/12/10)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#        endorse or promote products derived from this software without
#        specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use:
# Copy this file inside /scripts/actions directory
# Make the destination layer Active, select the shapes and run the action
# add the following code to the sfxuser.py to use it with a keyboard shortcut:
'''
def callMethod(func, *args, **kwargs):
    def _return_func():
        return func(*args, **kwargs)
    return _return_func

       
fx.bind('F5', callMethod(fx.actions["TransferShapes"].execute))
''' 
#===============================================================================


from fx import *
from tools.objectIterator import getObjects
from tools.objectIterator import ObjectFinder


def remove_keys(shape,propertiesList):
    for prop in propertiesList:
        propertie = shape.property(prop)
        editor = PropertyEditor(propertie)
        nkeys = propertie.numKeys
        if nkeys > 0:
            for t in reversed(xrange(nkeys)):
                editor.deleteKey(t)
        editor.execute()
        propertie.constant = True
    


class TransferShapes(Action):
    """Copy shapes to an Active Layer on a given frame.
"""

    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Transfer Shapes to Active Layer")

    def available(self):
        node = activeNode()
        session = activeSession()
        assert session, "Select a Session"
        rotoNode = session.node(type="RotoNode")
        assert rotoNode, "The session does not contain a Roto Node"
        activelayer = activeLayer()
        assert activelayer != None, "Activate the destinationn Layer"
        shapes = getObjects(selection(), types=[Shape])
        assert len(shapes) > 0, "There must be one or more selected shapes"

    def execute(self,deletekeys=True,propertiesList=["opacity"]):
        beginUndo("Transfer Shapes") 

        shapes = getObjects(selection(), types=[Shape])
        activelayer = activeLayer()
        if activelayer != None:
            thisframe_matrix = activelayer.getTransform(player.frame)
            selectionlist = []
            avoid_duplicates = []
            for shape in shapes:
                if shape.parent != activelayer and shape not in avoid_duplicates:
                    copy = shape.clone()
                    activelayer.property("objects").addObjects([copy])
                    pathProp = copy.property("path")
                    pathEditor = PropertyEditor(pathProp)
                    path = copy.evalPath(player.frame)
                    if shape.parent.type == "Layer":
                        identity = Matrix()
                        reverseparent = shape.parent.getTransform(player.frame)
                        offset_matrix = -thisframe_matrix  * reverseparent 
                        path.transform(offset_matrix)
                    elif shape.parent.type == "RotoNode":
                        identity = Matrix()
                        reverseparent = identity
                        offset_matrix = -thisframe_matrix  * reverseparent 
                        path.transform(offset_matrix)
                        
                    
                    pathEditor.setValue(path, player.frame)
                    keysn = pathProp.numKeys
                    keys = pathProp.keys
                    for t in reversed(xrange(keysn)):
                        if keys[t] != player.frame:
                            pathEditor.deleteKey(t)
                    pathEditor.execute()
                    
                    if deletekeys:
                        remove_keys(copy,propertiesList)
                    
                    selectionlist.append(copy)
                    avoid_duplicates.append(shape)
                if shape.parent == activelayer:
                    print "Active Layer is parent layer, nothing done."
                    selectionlist.append(shape)
            select(selectionlist)
        else:
            print "There's no active Layer, activate one!"
        endUndo()

addAction(TransferShapes())


