# Boundary Visual Effects - Change Outline Color
# Version 2.1
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will change the selected objects outline colors, you can cycle from preset colors or random.
#===============================================================================

#===============================================================================
# Version Log
# v2.1 (2013/08/12)
# If no shapes were selected , the script would throw an error (thanks Johnny Chan for catching that)
# Script can now change color os Layers and TRackers as well
# v2 (2012/11/01)
# Added the "cycle" preset colors mode, where you can place your favorite colors. Random is still available as default
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#        endorse or promote products derived from this software without
#        specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions:
# to use it as a keyboard shortcut, add the code below on sfxuser.py (without the ''')
'''
def callMethod(func, *args, **kwargs):
    def _return_func():
        return func(*args, **kwargs)
    return _return_func
 

fx.bind('shift+;', callMethod(fx.actions["ChangeOutlineColor"].execute, "cycle"))
fx.bind('shift+l', callMethod(fx.actions["ChangeOutlineColor"].execute, "random"))
'''
#===============================================================================

import random
from fx import *
from tools.objectIterator import getObjects


class ChangeOutlineColor(Action):
    """Change selected objects outline colors
"""

    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Change Outline Colors ")

    def available(self):
        objects = getObjects(selection(), types=[Shape,Tracker,Layer])
        assert len(objects) > 0, "There must be one or more selected objects"
        
    def execute(self, type="random"):
        objects = getObjects(selection(), types=[Shape,Tracker,Layer])
        
        if len(objects) == 0: #if the function is run via keybinding, abort for no selection
            return
        
        beginUndo("bvfx Change Outline Color") 

        if type == "cycle":
            red = Color(1.0,0.0,0.0,1.0)
            yellow = Color(1.0,1.0,0.0,1.0)
            purple = Color(0.5,0.0,0.5,1.0)
            orange = Color(1.0,0.5,0.0,1.0)
            green = Color(0.0,1.0,0.0,1.0)
            magenta = Color(1.0,0.0,1.0,1.0)
            cyan = Color(0.0,1.0,1.0,1.0)
            brown = Color(0.6,0.4,0.2,1.0)
            blue = Color(0.0,0.0,1.0,1.0)
            black = Color(0.0,0.0,0.0,1.0)
            white = Color(1.0,1.0,1.0,1.0)
            #===================================================================
            # #change list order to taste
            cyclecolorlist = [red,yellow,magenta,green,cyan,orange,blue,purple,brown,black,white]
            #===================================================================
            
            currentcolor = Color(1.0,0.0,0.0,1.0)
            if objects[0].type == "Shape":
                currentcolor = objects[0].property("outlineColor").getValue()
            elif objects[0].type == "Layer":
                try:
                    currentcolor = objects[0].property("color").getValue()
                except:
                    pass
            elif objects[0].type == "Tracker":
                try:
                    currentcolor = objects[0].property("pathColor").getValue()
                except:
                    pass
            
                
            if currentcolor in cyclecolorlist:
                if currentcolor == cyclecolorlist[-1]:
                    newcolor =  cyclecolorlist[0]
                else:
                    newcolor =  cyclecolorlist[cyclecolorlist.index(currentcolor)+1]
            else:
                newcolor =  cyclecolorlist[0]

        else: #running as random color mode
            rndcolor1 = random.random()
            rndcolor2 = random.random() 
            rndcolor3 = random.random() 
            newcolor = Color(rndcolor1,rndcolor2,rndcolor3,1)
        for obj in objects:
            if obj.selected:  #will avoid coloring shapes that are not selected inside a layer 
                if obj.type == "Shape":  
                    color = obj.property("outlineColor")        
                    color.setValue(newcolor)
                elif objects[0].type == "Layer":
                    try:              
                        color = obj.property("color")        
                        color.setValue(newcolor)
                    except:
                        pass      
                elif objects[0].type == "Tracker": 
                    try:
                        color = obj.property("pathColor")        
                        color.setValue(newcolor)   
                    except:
                        pass
        endUndo()

addAction(ChangeOutlineColor())


