#Boundary Visual Effects - Select Open Shapes
#Version 1.0
# 
#This Action enable you to select open shapes from a larger selection group/
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v4.1
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.
	


from fx import *
from tools.objectIterator import getObjects

class SelectOpenShapes(Action):
	"""Select only open shapes from your current selection
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Select Open Shapes")

	def available(self):
		shapes = getObjects(selection(), types=[Shape])
		assert len(shapes) > 0, "There must be one or more selected shapes"

	def execute(self):
		shapes = getObjects(selection(), types=[Shape])

		beginUndo("bvfx Select Open Shapes") 

		objects = []
		
		for shape in shapes:			
			if not shape.closed:		
				objects.append(shape) 
				
		
		
		select(objects)
					



		endUndo()

addAction(SelectOpenShapes())


