#Boundary Visual Effects - Activate Parent Layer
#Version 1.0
# 
# This action will make the objects parent Layer Active
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v4.1
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.
	

from fx import *
from tools.objectIterator import getObjects
from tools.objectIterator import ObjectFinder

class ActivateParentLayer(Action):
	"""Select the object parent layer
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Activate Parent Layer")

	def available(self):
		session = activeSession()
		assert session, "Select a Session"
		rotoNode = session.node(type="RotoNode")
		assert rotoNode, "The session does not contain a Roto Node"


	def execute(self):
		session = activeSession()
		shapes = getObjects(selection(), types=[Shape])
		rotoNode = session.node(type="RotoNode")
		layers = getObjects(rotoNode.children, types=[Layer])

		beginUndo("Activate Parent Layer") 
					

		if len(shapes) > 0:
			for shape in shapes:			
				if shape.parent.type == "Layer":
					setActiveLayer(shape.parent)
			



		endUndo()

addAction(ActivateParentLayer())


