# Boundary Visual Effects - bvfxSelectionSets
# Version 1.0
#
# For greetings, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will Save the current selection and Load the selection later
#===============================================================================
#===============================================================================
# TODO
# save selection sets on v5 project
#===============================================================================
#===============================================================================
# Version Log
# v1 (2013/04/15)
#===============================================================================

# Copyright (c) 2013, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#       endorse or promote products derived from this software without
#       specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
#===============================================================================
# By default the action will use keyboard shortcuts so save/load selection sets
# the objective is to quickly save/load the selection sets to use with IK/etc.
#
# Add the following elements to you sfxuser.py to create 10 selection sets with shortcuts
# I suggest Alt+Ctrl+ number and Ctrl+number to save/load, you can modify it to anything you want.
 
'''
def callMethod(func, *args, **kwargs):
    def _return_func():
        return func(*args, **kwargs)
    return _return_func
    
fx.bind('Alt+Ctrl+1', callMethod(fx.actions["bvfxSelectionSets"].execute,0, "save")) 
fx.bind('Ctrl+1', callMethod(fx.actions["bvfxSelectionSets"].execute,0, "load")) 
fx.bind('Alt+Ctrl+2', callMethod(fx.actions["bvfxSelectionSets"].execute,1, "save")) 
fx.bind('Ctrl+2', callMethod(fx.actions["bvfxSelectionSets"].execute,1, "load")) 
fx.bind('Alt+Ctrl+3', callMethod(fx.actions["bvfxSelectionSets"].execute,2, "save")) 
fx.bind('Ctrl+3', callMethod(fx.actions["bvfxSelectionSets"].execute,2, "load")) 
fx.bind('Alt+Ctrl+4', callMethod(fx.actions["bvfxSelectionSets"].execute,3, "save")) 
fx.bind('Ctrl+4', callMethod(fx.actions["bvfxSelectionSets"].execute,3, "load")) 
fx.bind('Alt+Ctrl+5', callMethod(fx.actions["bvfxSelectionSets"].execute,4, "save")) 
fx.bind('Ctrl+5', callMethod(fx.actions["bvfxSelectionSets"].execute,4, "load")) 
fx.bind('Alt+Ctrl+6', callMethod(fx.actions["bvfxSelectionSets"].execute,5, "save")) 
fx.bind('Ctrl+6', callMethod(fx.actions["bvfxSelectionSets"].execute,5, "load")) 
fx.bind('Alt+Ctrl+7', callMethod(fx.actions["bvfxSelectionSets"].execute,6, "save")) 
fx.bind('Ctrl+7', callMethod(fx.actions["bvfxSelectionSets"].execute,6, "load")) 
fx.bind('Alt+Ctrl+8', callMethod(fx.actions["bvfxSelectionSets"].execute,7, "save")) 
fx.bind('Ctrl+8', callMethod(fx.actions["bvfxSelectionSets"].execute,7, "load")) 
fx.bind('Alt+Ctrl+9', callMethod(fx.actions["bvfxSelectionSets"].execute,8, "save")) 
fx.bind('Ctrl+9', callMethod(fx.actions["bvfxSelectionSets"].execute,8, "load")) 
fx.bind('Alt+Ctrl+0', callMethod(fx.actions["bvfxSelectionSets"].execute,9, "save")) 
fx.bind('Ctrl+0', callMethod(fx.actions["bvfxSelectionSets"].execute,9, "load")) 

'''
#===============================================================================

from fx import *
from tools.objectIterator import getObjects

class bvfxSelectionSets(Action):
    """Select only open shapes from your current selection"""
    
    selectionsets =[None]*10
    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Selection Set")
    def available(self):
        shapes = getObjects(selection())
        assert len(shapes) > 0, "There must be one or more selected shapes/layers"
    def execute(self, saveslot=0, action ="save"):
        beginUndo("bvfx Selection Set") 
        selected = getObjects(selection())
        trueselection = []
        slot =[None]
        if action == "save":
            if len(selected)>0:
                for i in selected:
                    if i.selected:
                        if i.type == "Shape" and viewer.toolName == "Reshape":
                            #=======================================================
                            # for version 5 only
                            #=======================================================
                            if version >= 5:
                                slot.append([i,i.selectedPoints()])
                            trueselection.append(i)
                        else:
                            trueselection.append(i)
            slot[0] = trueselection
            bvfxSelectionSets.selectionsets[saveslot] = slot# trueselection
            status("Selection Set " + str(saveslot) + " saved")
        if action == "load":
            if bvfxSelectionSets.selectionsets[saveslot]: #test if the slot is not empty
                if len(bvfxSelectionSets.selectionsets[saveslot][0]) > 0:
                   for i in range(1,len(bvfxSelectionSets.selectionsets[saveslot])):
                        shape = bvfxSelectionSets.selectionsets[saveslot][i][0]
                        points = bvfxSelectionSets.selectionsets[saveslot][i][1]
                        shape.selectAllPoints(state=False)
                        shape.selectPoints(points)
                select(bvfxSelectionSets.selectionsets[saveslot][0])                    
                status("Selection Set " + str(saveslot) + " loaded")
                
        endUndo()
        #=======================================================================
        # v5 only
        #=======================================================================
        if version >= 5:
            viewer.update()
addAction(bvfxSelectionSets())


