# Boundary Visual Effects - Organize Session
# Version 1.1
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.2.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will help you quickly organize your project:
#
# It will create a layer called "helpers" at root level (checks if there's one already)
# It will color all the Mocha imported shapes into Cyan
# And It will select all shapes imported from Mocha and also all the trackers of the scene left in the project root level
# and move them to the HELPERS layer
# 
#===============================================================================

#===============================================================================
# Version Log
# v1 (2012/11/01)
# v1.1 (2012/12/10)
# Move the trackers/shapes automagically to the helper layer (finally!)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#        endorse or promote products derived from this software without
#        specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
# Just run it from Actions menu
# Or add the following code to the sfxuser.py to use it with a keyboard shortcut:
'''
def callMethod(func, *args, **kwargs):
    def _return_func():
        return func(*args, **kwargs)
    return _return_func

       
fx.bind('F5', callMethod(fx.actions["OrganizeSession"].execute))
''' 
#===============================================================================


from fx import *
from tools.objectIterator import getObjects
from tools.objectIterator import ObjectFinder
try: 
    import re 
    import threading
except:
    print "You need to install Python on your system"
    pass


def create():
    node = activeNode()
    session = node.session
    layer = Layer("HELPERS")
    layer.visible = False
    node.property("objects").addObjects([layer])
    return layer

def move(trk, target):
    copy = trk.clone()
    target.property("objects").addObjects([copy])
    delete([trk])

class OrganizeSession(Action):
    """Organize Sessions by selecting Imported Mocha Shapes and also Trackeers
"""

    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Organize Session")

    def available(self):
        node = activeNode()
        session = activeSession()
        assert session, "Select a Session"
        rotoNode = session.node(type="RotoNode")
        assert rotoNode, "The session does not contain a Roto Node"

    def execute(self):
        session = activeSession()
        rotoNode = session.node(type="RotoNode")
        layers = getObjects(rotoNode.children, types=[Layer])
        shapes = getObjects(rotoNode.children, types=[Shape])
        trackers = getObjects(rotoNode.children, types=[Tracker])
        beginUndo("Organize Session") 
        
        exists = False
        newcolor = Color(0,1,1,1)
            
        if len(layers) > 0:
            for layer in layers:
                if layer.parent.type == "RotoNode":
                    if layer.label == "HELPERS":
                        exists = True
                        target = layer
            
            if exists == False:
                target = create()
                
        else:
            target = create()
            
            
        n=0
        if len(shapes) > 0:
            for shape in shapes:
                try: #if there is no re module, skip
                    p = re.compile('\w+_[0-9]+_mask')
                    if shape.parent.type == "RotoNode" and p.search(shape.label):
                        color = shape.property("outlineColor")        
                        color.setValue(newcolor)
                        copy = shape.clone()
                        target.property("objects").addObjects([copy])
                        delete([shape])
                        n+=1
                except:
                    pass
        
        if len(trackers) > 0:
            for trk in trackers:
                if trk.parent.type == "RotoNode":
                    n +=1
                    threading.Thread(None, move, args=(trk,target)).start()
        #===============================================================
        # dummy update to viewer because of threading
        #===============================================================
        layer = Layer("dummy")
        node = activeNode()
        node.property("objects").addObjects([layer])
        delete([layer])
        #end

        msg = "ORGANIZE PROJECT: Moved " + str(n) + " objects\n"
        status(msg)
        print msg
        endUndo()

addAction(OrganizeSession())


