# bvfx_CompNoOverlay_Combo v1.2
# Version 1.2
# Have you ever finding yourself pressing "4" for composite mode and them "0" to remove the overlay several times a day?
# This script creates a special combo mode of composite with no overlay, with 3 bg colors options: neutral grey, white and black
#
# Created by Magno Borgo
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v3 and up
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com
#
# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#		endorse or promote products derived from this software without
#		specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
#Version log:
#v1.2 fixed the conflicting with default shortcuts with other Nodes (keyer, powe matte, etc)
# changed the shortcut of View: channels to 8
#v1.1 fixed silhouette 4.5 bg color update that disable the functionality of the script

#USAGE
# Press the shortcuts 5, 6, or 7 to enable the combo mode, and press again to go back to the last view mode used before the script activation.


import fx

def callMethod(func, *args, **kwargs):
	def _return_func():
		return func(*args, **kwargs)
	return _return_func


toggle = False
last_toggle = None
store_last_mode = None

def toggleCompNoOverlay(bgcolor):
	global toggle, store_last_mode, last_toggle 
	colordict = {"gray": fx.Color(0.5, 0.5, 0.5, 1), "black": fx.Color(0, 0, 0, 1), "white": fx.Color(1, 1, 1, 1)}
	bindlist = {"gray":4, "black":5, "white":6} 
	node = fx.activeNode()
	session = fx.activeSession()
	if fx.activeNode() == session.node(type="RotoNode"):
	  	prop = node.property("alpha.invert")
	  	prop_value = node.property("alpha.invert").getValue()
	  	if prop_value == True:
			prop.setValue(False)
			prop.setValue(True)
		else:   	
			prop.setValue(True)
			prop.setValue(False)
		if bgcolor == "channels":
			 fx.viewer.setViewMode(4)
		else:
			
			if fx.activeNode() == session.node(type="RotoNode"):
				if last_toggle == None or last_toggle == bgcolor:
					toggle = not toggle
					
		        if toggle:
		            if last_toggle == None:
		                store_last_mode = fx.viewer.viewMode
		            fx.viewer.setOverlay(False)            
		            fx.prefs["composite.backgroundColor"] = colordict[bgcolor]
		            
		            fx.viewer.setViewMode(3)
		            last_toggle = bgcolor
		        else:
		            fx.viewer.setOverlay(True)
		            fx.viewer.setViewMode(store_last_mode)
		            last_toggle = None
			
	if fx.activeNode() != session.node(type="RotoNode"):
		if bgcolor != "channels":
			fx.viewer.setViewMode(bindlist[bgcolor])
    
    
fx.bind("5", callMethod(toggleCompNoOverlay, "gray"))
fx.bind("6", callMethod(toggleCompNoOverlay, "black"))
fx.bind("7", callMethod(toggleCompNoOverlay, "white"))
fx.bind("8", callMethod(toggleCompNoOverlay, "channels"))
