# Boundary Visual Effects - Open Scripts Path
# Version 1.0
#
# For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
# Compatibility: Silhouette v4.1 and up, not tested in previous versions
#
# If you like it and use it frequently, please consider a small donation to the author,
# via Paypal on the email mborgo[at]boundaryvfx.com

#===============================================================================
# This action will open the silhouette scripts path on Finder/Explorer
# 
#===============================================================================

#===============================================================================
# Version Log
# v1 (2012/12/11)
#===============================================================================

# Copyright (c) 2012, Magno Borgo
# All rights reserved.
#
# BSD-style license:
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Magno Borgo or its contributors may be used to
#        endorse or promote products derived from this software without
#        specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
#BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
#OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
#OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#===============================================================================
# Instructions to use
# Just run it from Actions menu
#===============================================================================


from fx import *
import subprocess, sys

class OpenScriptPath(Action):
    """Open the script path on Finder
"""

    def __init__(self):
        Action.__init__(self, "BoundaryVFX|Open Script Directory")

    def available(self):
        pass

    def execute(self):
        path = buildPath("$(SFX_RESOURCE_PATH)/scripts")
        
        if sys.platform == 'darwin':
            print "Opening path in Finder:", path
            subprocess.call(["open", "-R", path])
        elif sys.platform == 'linux2':
            print "Opening path in Gnome:", path
            subprocess.call(['gnome-open', '--', path])
        elif sys.platform == 'windows':
            print "Opening path in Explorer:", path
            subprocess.call(['explorer', path])

addAction(OpenScriptPath())


