#Boundary Visual Effects - Hide Parent Layer
#Version 1.0
# 
# This action will enable you to hide the shape parent layer.
# Using this script without selecting anything you'll show all layers hidden, except the ones locked.
#
#Created by Magno Borgo
#For greeting, bugs, and requests email me at mborgo[at]boundaryvfx.com
#Compatibility: Silhouette v4.1
#
#
#Legal stuff:
#This script is provided "as is," without warranty of any kind, expressed
#or implied. In no event shall the author be held liable for any damages 
#arising in any way from the use of this script.
	

from fx import *
from tools.objectIterator import getObjects

class HideParentLayer(Action):
	"""Turn the parent of the selected shape visibility off
"""

	def __init__(self):
		Action.__init__(self, "BoundaryVFX|Hide Parent Layer")

	def available(self):
		session = activeSession()
		assert session, "Select a Session"
		rotoNode = session.node(type="RotoNode")
		assert rotoNode, "The session does not contain a Roto Node"


	def execute(self):
		session = activeSession()
		shapes = getObjects(selection(), types=[Shape])
		rotoNode = session.node(type="RotoNode")
		layers = getObjects(rotoNode.children, types=[Layer])

		beginUndo("bvfx Hide Parent Layer") 

		if len(shapes) > 0:
			for shape in shapes:			
				if shape.parent.type == "Layer":
					shape.parent.visible = False
				
		else:
			
			for layer in layers:
				if layer.locked != True:
					layer.visible = True
				
	
		endUndo()

addAction(HideParentLayer())


